<?php
/**
 * Unified Files API - Handles both upload and delete operations
 * Remote Server: https://test.glint.one/my/files/
 * API Key: G21K07X91KRAR68JWE4FI8RXQBYZWHZH
 */

// Set JSON header for all responses
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Only allow POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode([
        'success' => false,
        'error' => 'Method not allowed. Only POST requests are accepted.'
    ]);
    exit();
}

// Configuration
$API_KEY = 'G21K07X91KRAR68JWE4FI8RXQBYZWHZH';
$UPLOAD_DIR = 'uploads/files/';
$MAX_FILE_SIZE = 50 * 1024 * 1024; // 50MB
$ALLOWED_EXTENSIONS = ['jpg', 'jpeg', 'png', 'gif', 'webp', 'pdf', 'doc', 'docx', 'xls', 'xlsx', 'txt', 'zip', 'rar', 'php'];

// Function to send JSON response
function sendResponse($success, $message = '', $data = []) {
    $response = [
        'success' => $success,
        'message' => $message
    ];
    
    if (!empty($data)) {
        $response = array_merge($response, $data);
    }
    
    echo json_encode($response);
    exit();
}

// Function to validate API key
function validateApiKey($api_key) {
    global $API_KEY;
    return $api_key === $API_KEY;
}

// Function to validate file
function validateFile($file) {
    global $MAX_FILE_SIZE, $ALLOWED_EXTENSIONS;
    
    // Check for upload errors
    if ($file['error'] !== UPLOAD_ERR_OK) {
        return [
            'valid' => false,
            'error' => 'File upload failed with error code: ' . $file['error']
        ];
    }
    
    // Check file size
    if ($file['size'] > $MAX_FILE_SIZE) {
        return [
            'valid' => false,
            'error' => 'File size exceeds maximum allowed size (50MB)'
        ];
    }
    
    // Check file extension
    $file_extension = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
    if (!in_array($file_extension, $ALLOWED_EXTENSIONS)) {
        return [
            'valid' => false,
            'error' => 'File type not allowed. Allowed types: ' . strtoupper(implode(', ', $ALLOWED_EXTENSIONS))
        ];
    }
    
    return [
        'valid' => true,
        'extension' => $file_extension
    ];
}

// Function to generate unique filename
function generateUniqueFilename($original_name, $extension) {
    return uniqid() . '_' . time() . '.' . $extension;
}

// Function to get file URL
function getFileUrl($filename) {
    $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
    $host = $_SERVER['HTTP_HOST'];
    $script_path = dirname($_SERVER['SCRIPT_NAME']);
    return $protocol . '://' . $host . $script_path . '/' . $filename;
}

// Get request parameters
$action = $_POST['action'] ?? '';
$api_key = $_POST['api_key'] ?? '';

// Validate API key
if (!validateApiKey($api_key)) {
    sendResponse(false, 'Invalid API key');
}

// Handle different actions
switch ($action) {
    case 'upload':
        handleUpload();
        break;
    case 'delete':
        handleDelete();
        break;
    default:
        sendResponse(false, 'Invalid action. Supported actions: upload, delete');
}

// Handle file upload
function handleUpload() {
    global $UPLOAD_DIR;
    
    // Check if file was uploaded
    if (!isset($_FILES['file'])) {
        sendResponse(false, 'No file received');
    }
    
    $file = $_FILES['file'];
    $filename = $_POST['filename'] ?? '';
    
    // Validate file
    $validation = validateFile($file);
    if (!$validation['valid']) {
        sendResponse(false, $validation['error']);
    }
    
    // Generate unique filename if not provided
    if (empty($filename)) {
        $filename = generateUniqueFilename($file['name'], $validation['extension']);
    }
    
    // Create upload directory if it doesn't exist
    if (!file_exists($UPLOAD_DIR)) {
        mkdir($UPLOAD_DIR, 0755, true);
    }
    
    $upload_path = $UPLOAD_DIR . $filename;
    
    // Move uploaded file
    if (move_uploaded_file($file['tmp_name'], $upload_path)) {
        $file_url = getFileUrl($upload_path);
        
        sendResponse(true, 'File uploaded successfully', [
            'file_url' => $file_url,
            'file_name' => $file['name'],
            'file_size' => $file['size'],
            'file_type' => $file['type']
        ]);
    } else {
        sendResponse(false, 'Failed to upload file to server');
    }
}

// Handle file deletion
function handleDelete() {
    global $UPLOAD_DIR;
    
    $file_url = $_POST['file_url'] ?? '';
    
    if (empty($file_url)) {
        sendResponse(false, 'No file URL provided');
    }
    
    // Extract file path from URL
    $parsed_url = parse_url($file_url);
    $file_path = ltrim($parsed_url['path'], '/');
    
    // Remove the base path to get the relative file path
    // URL: https://test.glint.one/my/files/uploads/files/filename.txt
    // Path: /my/files/uploads/files/filename.txt
    // We need: uploads/files/filename.txt
    
    $base_path = '/my/files/';
    if (strpos($file_path, $base_path) === 0) {
        $file_path = substr($file_path, strlen($base_path));
    }
    
    // Alternative: extract filename from the URL and construct path
    $filename = basename($file_path);
    $file_path = $UPLOAD_DIR . $filename;
    
    // Debug logging
    error_log("Delete attempt - Original URL: $file_url");
    error_log("Delete attempt - Extracted path: $file_path");
    error_log("Delete attempt - File exists: " . (file_exists($file_path) ? 'Yes' : 'No'));
    
    // Check if file exists
    if (!file_exists($file_path)) {
        sendResponse(false, 'File not found on server: ' . $file_path);
    }
    
    // Delete file
    if (unlink($file_path)) {
        sendResponse(true, 'File deleted successfully');
    } else {
        sendResponse(false, 'Failed to delete file from server');
    }
}

// If we reach here, something went wrong
sendResponse(false, 'Unknown error occurred');
?>
